
<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('academics.track'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>
    <section class="sms-breadcrumb mb-20">
        <div class="container-fluid">
            <div class="row justify-content-between">
                <h1><?php echo app('translator')->get('academics.track'); ?></h1>
                <div class="bc-pages">
                    <a href="<?php echo e(route('dashboard')); ?>"><?php echo app('translator')->get('academics.dashboard'); ?></a>
                    <a><?php echo app('translator')->get('academics.academics'); ?></a>
                    <a><?php echo app('translator')->get('academics.track'); ?></a>
                </div>
            </div>
        </div>
    </section>

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">


            <div class="row">
                <!-- Form Section -->
                <div class="col-lg-4 col-xl-3">
                    <div class="white-box">
                        <div class="main-title">
                            <h3 class="mb-15">
                                <?php if(isset($track)): ?>
                                    <?php echo app('translator')->get('academics.edit_track'); ?>
                                <?php else: ?>
                                    <?php echo app('translator')->get('academics.add_track'); ?>
                                <?php endif; ?>
                            </h3>
                        </div>

                        <?php if(isset($track)): ?>
                            <?php echo e(Form::open(['class' => 'form-horizontal', 'files' => true, 'route' => ['tracks_update', $track->id], 'method' => 'PUT', 'enctype' => 'multipart/form-data'])); ?>

                        <?php else: ?>
                            <?php if(userPermission('tracks_store')): ?>
                                <?php echo e(Form::open([
                                    'class' => 'form-horizontal',
                                    'files' => true,
                                    'route' => 'tracks_store',
                                    'method' => 'POST',
                                    'enctype' => 'multipart/form-data',
                                ])); ?>

                            <?php endif; ?>
                        <?php endif; ?>
                        <div class="add-visitor">
                            <!-- Track Name EN -->

                            <div class="row mt-25">
                                <div class="col-lg-12">
                                    <div class="primary_input">
                                        <label class="primary_input_label" for=""><?php echo app('translator')->get('common.categories'); ?>
                                        </label>
                                        <select
                                            class="primary_select  form-control <?php echo e($errors->has('cat_id') ? ' is-invalid' : ''); ?>"
                                            name="cat_id" id="cat_id">
                                            <option data-display="<?php echo app('translator')->get('common.categories'); ?> *" value=""><?php echo app('translator')->get('common.categories'); ?>
                                                *</option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>"
                                                    <?php echo e(old('cat_id', isset($track) ? $track->id : '') == $item->id ? 'selected' : ''); ?>>
                                                    <?php echo e(app()->getLocale() == 'en' ? $item->name_en : $item->name_ar); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <?php if($errors->has('cat_id')): ?>
                                            <span class="text-danger invalid-select" role="alert">
                                                <?php echo e($errors->first('cat_id')); ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-25">
                                <div class="col-lg-12">
                                    <div class="primary_input">
                                        <label for="track_name_en"><?php echo app('translator')->get('academics.track_name_en'); ?> <span class="text-danger">
                                                *</span></label>
                                        <input
                                            class="primary_input_field form-control <?php echo e($errors->has('track_name_en') ? 'is-invalid' : ''); ?>"
                                            type="text" id="track_name_en" name="track_name_en"
                                            value="<?php echo e(old('track_name_en', isset($track) ? $track->track_name_en : '')); ?>">
                                        <?php $__errorArgs = ['track_name_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>

                            <!-- Track Name AR -->
                            <div class="row mt-25">
                                <div class="col-lg-12">
                                    <div class="primary_input">
                                        <label for="track_name_ar"><?php echo app('translator')->get('academics.track_name_ar'); ?> <span class="text-danger">
                                                *</span></label>
                                        <input
                                            class="primary_input_field form-control <?php echo e($errors->has('track_name_ar') ? 'is-invalid' : ''); ?>"
                                            type="text" id="track_name_ar" name="track_name_ar"
                                            value="<?php echo e(old('track_name_ar', isset($track) ? $track->track_name_ar : '')); ?>">
                                        <?php $__errorArgs = ['track_name_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>

                            <!-- Level Number -->
                            <div class="row mt-25">
                                <div class="col-lg-12">
                                    <label class="primary_input_label" for="level_number">
                                        <?php echo app('translator')->get('academics.level_number'); ?> <span class="text-danger"> *</span>
                                    </label>
                                    <select
                                        class="primary_select form-control <?php echo e($errors->has('level_number') ? 'is-invalid' : ''); ?>"
                                        id="level_number" name="level_number">
                                        <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($level->id); ?>"
                                                <?php echo e(old('level_number', isset($track) ? $track->level_number : '') == $level->id ? 'selected' : ''); ?>>
                                                <?php echo e($level->level_number); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['level_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger invalid-select" role="alert"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <!-- session -->
                            <div class="row mt-25">
                                <div class="col-lg-12">
                                    <label class="primary_input_label" for="session">
                                        <?php echo app('translator')->get('academics.session'); ?> <span class="text-danger"> *</span>
                                    </label>
                                    <select
                                        class="primary_select form-control <?php echo e($errors->has('session') ? 'is-invalid' : ''); ?>"
                                        id="session" name="session">
                                        <?php for($i = 1; $i <= 20; $i++): ?>
                                            <option value="<?php echo e($i); ?>"
                                                <?php echo e(old('session', isset($track) ? $track->session : '') == $i ? 'selected' : ''); ?>>
                                                <?php echo e($i); ?>

                                            </option>
                                        <?php endfor; ?>
                                    </select>
                                    <?php $__errorArgs = ['session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger invalid-select" role="alert"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <!-- Schedule -->
                            <div class="row mt-25">
                                <div class="col-lg-12">
                                    <label class="primary_input_label" for="schedule">
                                        <?php echo app('translator')->get('academics.schedule'); ?> <span class="text-danger"> *</span>
                                    </label>
                                    <select
                                        class="primary_select form-control <?php echo e($errors->has('schedule') ? 'is-invalid' : ''); ?>"
                                        id="schedule" name="schedule">
                                        <option value="once"
                                            <?php echo e(old('schedule', isset($track) ? $track->schedule : '') == 'once' ? 'selected' : ''); ?>>
                                            <?php echo app('translator')->get('academics.once'); ?>
                                        </option>
                                        <option value="twice"
                                            <?php echo e(old('schedule', isset($track) ? $track->schedule : '') == 'twice' ? 'selected' : ''); ?>>
                                            <?php echo app('translator')->get('academics.twice'); ?>
                                        </option>
                                    </select>
                                    <?php $__errorArgs = ['schedule'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger invalid-select" role="alert"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <!-- Valid For -->
                            <div class="row mt-25">
                                <div class="col-lg-12">
                                    <label class="primary_input_label" for="valid_for">
                                        <?php echo app('translator')->get('academics.valid_for'); ?> <span class="text-danger"> *</span>
                                    </label>
                                    <select
                                        class="primary_select form-control <?php echo e($errors->has('valid_for') ? 'is-invalid' : ''); ?>"
                                        id="valid_for" name="valid_for[]" multiple>
                                        <?php $__currentLoopData = $valid_for; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($type->id); ?>"
                                                <?php echo e(in_array($type->id, old('valid_for', isset($track) ? json_decode($track->valid_for, true) : [])) ? 'selected' : ''); ?>>
                                                <?php echo e($type->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['valid_for'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger invalid-select" role="alert"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="row mt-40">
                                <div class="col-lg-12 text-center">
                                    <button type="submit" class="primary-btn fix-gr-bg submit" data-toggle="tooltip" title="">
                                        <span class="ti-check"></span>
                                        <?php if(isset($track)): ?>
                                            <?php echo app('translator')->get('academics.update_track'); ?>
                                        <?php else: ?>
                                            <?php echo app('translator')->get('academics.save_track'); ?>
                                        <?php endif; ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <?php echo e(Form::close()); ?>

                    </div>
                </div>

                <!-- Track List Section -->
                <div class="col-lg-8 col-xl-9">
                    <div class="white-box">
                        <div class="main-title">
                            <h3 class="mb-15"><?php echo app('translator')->get('academics.track_list'); ?></h3>
                        </div>
                        <?php if (isset($component)) { $__componentOriginal163c8ba6efb795223894d5ffef5034f5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal163c8ba6efb795223894d5ffef5034f5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.table','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                            <table id="table_id" class="table Crm_table_active3">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('academics.track_name_en'); ?></th>
                                        <th><?php echo app('translator')->get('academics.level_number'); ?></th>
                                        <th><?php echo app('translator')->get('academics.schedule'); ?></th>
                                        <th><?php echo app('translator')->get('academics.action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $tracks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $track): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($track->track_name_en); ?></td>
                                            <td><?php echo e($track->level_number); ?></td>
                                            <td><?php echo e($track->schedule); ?></td>
                                            <td>
                                                <?php if (isset($component)) { $__componentOriginalf5ee9bc45d6af00850b10ff7521278be = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf5ee9bc45d6af00850b10ff7521278be = $attributes; } ?>
<?php $component = App\View\Components\DropDown::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('drop-down'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\DropDown::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                                    
                                                    <?php if(userPermission('track_levels')): ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('track_levels', [$track->id])); ?>">
                                                            <?php echo app('translator')->get('common.levels'); ?></a>
                                                    <?php endif; ?>
                                                    <?php if(userPermission('assigned_pricing_plan')): ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('tracksPricingPlan', [$track->id])); ?>">
                                                            <?php echo app('translator')->get('common.pricing_plan'); ?></a>
                                                    <?php endif; ?>
                                                    <?php if(userPermission('tracks_edit')): ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('tracks_edit', [$track->id])); ?>"><?php echo app('translator')->get('common.edit'); ?></a>
                                                    <?php endif; ?>
                                                    <?php if(userPermission('track_delete')): ?>
                                                        <a class="dropdown-item" data-toggle="modal"
                                                            data-target="#deletetrackModal<?php echo e($track->id); ?>"
                                                            href="#"><?php echo app('translator')->get('common.delete'); ?></a>
                                                    <?php endif; ?>
                                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf5ee9bc45d6af00850b10ff7521278be)): ?>
<?php $attributes = $__attributesOriginalf5ee9bc45d6af00850b10ff7521278be; ?>
<?php unset($__attributesOriginalf5ee9bc45d6af00850b10ff7521278be); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf5ee9bc45d6af00850b10ff7521278be)): ?>
<?php $component = $__componentOriginalf5ee9bc45d6af00850b10ff7521278be; ?>
<?php unset($__componentOriginalf5ee9bc45d6af00850b10ff7521278be); ?>
<?php endif; ?>
                                            </td>
                                        </tr>
                                        <div class="modal fade admin-query" id="deletetrackModal<?php echo e($track->id); ?>">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title"><?php echo app('translator')->get('academics.delete_track'); ?></h4>
                                                        <button type="button" class="close"
                                                            data-dismiss="modal">&times;</button>
                                                    </div>

                                                    <div class="modal-body">
                                                        <div class="text-center">
                                                            <h4><?php echo app('translator')->get('common.are_you_sure_to_delete'); ?></h4>
                                                        </div>

                                                        <div class="mt-40 d-flex justify-content-between">
                                                            <button type="button" class="primary-btn tr-bg"
                                                                data-dismiss="modal"><?php echo app('translator')->get('common.cancel'); ?></button>
                                                            <?php echo e(Form::open(['route' => ['tracks_delete', $track->id], 'method' => 'DELETE', 'enctype' => 'multipart/form-data'])); ?>

                                                            <button class="primary-btn fix-gr-bg"
                                                                type="submit"><?php echo app('translator')->get('common.delete'); ?></button>
                                                            <?php echo e(Form::close()); ?>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                            </table>
                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal163c8ba6efb795223894d5ffef5034f5)): ?>
<?php $attributes = $__attributesOriginal163c8ba6efb795223894d5ffef5034f5; ?>
<?php unset($__attributesOriginal163c8ba6efb795223894d5ffef5034f5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal163c8ba6efb795223894d5ffef5034f5)): ?>
<?php $component = $__componentOriginal163c8ba6efb795223894d5ffef5034f5; ?>
<?php unset($__componentOriginal163c8ba6efb795223894d5ffef5034f5); ?>
<?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backEnd.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\tailors-dev\upedia\resources\views/backEnd/academics/tracks.blade.php ENDPATH**/ ?>