
<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('student.lets_assigned'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    <style>
        .badge {
            background: var(--primary-color);
            color: #fff;
            padding: 5px 10px;
            border-radius: 30px;
            display: inline-block;
            font-size: 8px;
        }

        .icon-only [class*="ti-"] {
            color: #fff;
            font-size: 14px;
        }

        .icon-only:hover [class*="ti-"] {
            color: #fff !important;
        }

        .table thead td {
            text-align: left;
        }

        .table tbody td {
            padding: 10px 12px 10px 12px;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('mainContent'); ?>

    <section class="sms-breadcrumb">
        <div class="container-fluid">
            <div class="row justify-content-between">
                <h1><?php echo app('translator')->get('common.invoices'); ?></h1>
                <div class="bc-pages">
                    <a href="<?php echo e(route('dashboard')); ?>"><?php echo app('translator')->get('common.dashboard'); ?></a>
                    <a><?php echo app('translator')->get('academics.academics'); ?></a>
                    <a><?php echo app('translator')->get('common.invoices'); ?></a>
                </div>
            </div>
        </div>
    </section>

    <section class="student-details">
        <div class="container-fluid p-0">
            <div class="row">
                <!-- Start Student Details -->
                <div class="col-lg-12 student-details up_admin_visitor">
                    <div class="white-box mt-40">
                        <div class="d-flex justify-content-between mb-20">
                            <h3>
                                <?php echo app('translator')->get('common.invoices'); ?>

                            </h3>
                            <a class="primary-btn-small-input primary-btn small fix-gr-bg" 
                            href="<?php echo e(route('create_invoice')); ?>"> <span class="ti-plus pr-2"></span>
                                <?php echo app('translator')->get('common.create_invoice'); ?></a>
                        </div>
                        <div class="table-responsive">
                            <table id="" class="table simple-table school-table" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('common.student_name'); ?></th>
                                        <th><?php echo app('translator')->get('common.invoice_number'); ?></th>
                                        <th><?php echo app('translator')->get('common.bill_status'); ?></th>
                                        <th><?php echo app('translator')->get('common.payment_status'); ?></th>

                                        <th><?php echo app('translator')->get('common.delivery_note'); ?></th>
                                        <th><?php echo app('translator')->get('common.action'); ?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        
                                        <tr>
                                            <td><?php echo e($item->student->full_name); ?></td>
                                            <td><?php echo e($item->invoice_number); ?></td>
                                            <td>
                                                <span
                                                    class="badge <?php if($item->bill_status === 'pending'): ?> badge-warning <?php elseif($item->bill_status === 'billed'): ?>badge-success <?php elseif($item->bill_status === 'cancelled'): ?>badge-danger <?php endif; ?>">
                                                    <?php echo e(__('common.' . $item->bill_status)); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <span
                                                    class="badge <?php if($item->payment_status === 'refunded'): ?> badge-refunded <?php elseif($item->payment_status === 'paid'): ?>badge-success <?php elseif($item->payment_status === 'not_paid'): ?>badge-danger  <?php elseif($item->payment_status === 'paid_purchased'): ?>badge-purchased <?php endif; ?> ">
                                                    <?php echo e(__('common.' . $item->payment_status)); ?>


                                                </span>
                                            </td>
                                            <td><?php echo e($item->delivery_note); ?></td>
                                            <td>

                                                <?php if (isset($component)) { $__componentOriginalf5ee9bc45d6af00850b10ff7521278be = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf5ee9bc45d6af00850b10ff7521278be = $attributes; } ?>
<?php $component = App\View\Components\DropDown::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('drop-down'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\DropDown::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>

                                                    <a class="dropdown-item text-left"
                                                        href="<?php echo e(route('finance_invoice', ['id' => $item->id])); ?>"> <i
                                                            class="fas fa-print"></i> <?php echo app('translator')->get('common.print'); ?> </a>



                                                    <a class="dropdown-item text-left" data-toggle="modal"
                                                        data-target="#changePaymentStatus<?php echo e($item->id); ?>"
                                                        href="#"><i class="fas fa-wallet"></i> <?php echo app('translator')->get('common.payment_status'); ?> </a>
                                                    <a class="dropdown-item text-left" data-toggle="modal"
                                                        data-target="#bill_status<?php echo e($item->id); ?>" href="#">
                                                        <i class="fas fa-wifi"></i> <?php echo app('translator')->get('common.bill_status'); ?> </a>

                                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf5ee9bc45d6af00850b10ff7521278be)): ?>
<?php $attributes = $__attributesOriginalf5ee9bc45d6af00850b10ff7521278be; ?>
<?php unset($__attributesOriginalf5ee9bc45d6af00850b10ff7521278be); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf5ee9bc45d6af00850b10ff7521278be)): ?>
<?php $component = $__componentOriginalf5ee9bc45d6af00850b10ff7521278be; ?>
<?php unset($__componentOriginalf5ee9bc45d6af00850b10ff7521278be); ?>
<?php endif; ?>


                                                <div class="modal fade admin-query"
                                                    id="changePaymentStatus<?php echo e(@$item->id); ?>">
                                                    <form action="<?php echo e(route('change_payment_status', [@$item->id])); ?>"
                                                        method="POST">
                                                        <?php echo e(csrf_field()); ?>

                                                        <div class="modal-dialog modal-dialog-centered">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h4 class="modal-title"><?php echo app('translator')->get('common.payment_status'); ?></h4>
                                                                    <button type="button" class="close"
                                                                        data-dismiss="modal">&times;</button>
                                                                </div>

                                                                <div class="modal-body">
                                                                    <div class="form-group">
                                                                        <label for=""><?php echo app('translator')->get('common.payment_status'); ?></label>
                                                                        <select name="payment_status" id="payment_status"
                                                                            class="primary_select">
                                                                            <option value="paid"
                                                                                <?php if($item->payment_status == 'paid'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('common.paid')); ?></option>
                                                                            <option value="not_paid"
                                                                                <?php if($item->payment_status == 'not_paid'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('common.not_paid')); ?></option>
                                                                            <option value="refunded"
                                                                                <?php if($item->payment_status == 'refunded'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('common.refunded')); ?></option>
                                                                            <option value="paid_purchased"
                                                                                <?php if($item->payment_status == 'paid_purchased'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('common.paid_purchased')); ?></option>
                                                                        </select>
                                                                    </div>


                                                                </div>
                                                                <div class="modal-footer">
                                                                    <div class="mt-40 d-flex justify-content-between">
                                                                        <button type="button" class="primary-btn tr-bg"
                                                                            data-dismiss="modal"><?php echo app('translator')->get('common.cancel'); ?></button>
                                                                        <button class="primary-btn fix-gr-bg mx-1"
                                                                            type="submit"><?php echo app('translator')->get('common.submit'); ?></button>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                                <div class="modal fade admin-query" id="bill_status<?php echo e(@$item->id); ?>">
                                                    <form action="<?php echo e(route('change_bill_status', [@$item->id])); ?>"
                                                        method="POST">
                                                        <?php echo e(csrf_field()); ?>

                                                        <div class="modal-dialog modal-dialog-centered">

                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h4 class="modal-title"><?php echo app('translator')->get('common.bill_status'); ?></h4>
                                                                    <button type="button" class="close"
                                                                        data-dismiss="modal">&times;</button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="form-group">
                                                                        <label for=""><?php echo app('translator')->get('common.bill_status'); ?></label>
                                                                        <select name="bill_status" id="bill_status"
                                                                            class="primary_select">
                                                                            <option value="pending"
                                                                                <?php if($item->bill_status == 'pending'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('common.pending')); ?></option>
                                                                            <option value="billed"
                                                                                <?php if($item->bill_status == 'billed'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('common.billed')); ?></option>
                                                                            <option value="cancelled"
                                                                                <?php if($item->bill_status == 'cancelled'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('common.cancelled')); ?></option>

                                                                        </select>
                                                                    </div>


                                                                </div>
                                                                <div class="modal-footer">
                                                                    <div class="mt-40 d-flex justify-content-between">
                                                                        <button type="button" class="primary-btn tr-bg"
                                                                            data-dismiss="modal"><?php echo app('translator')->get('common.cancel'); ?></button>
                                                                        <button class="primary-btn fix-gr-bg mx-1"
                                                                            type="submit"><?php echo app('translator')->get('common.submit'); ?></button>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- End Student Details -->
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>


<style>
    .badge {
        font-size: 12px !important;
    }

    .badge-success {
        background: #080 !important;

    }

    .badge-success {
        background: #080 !important;

    }

    .badge-warning {
        background: rgb(81, 81, 81) !important;

    }

    .badge-danger {
        background: rgb(255, 10, 10) !important;
    }

    .badge-refunded {
        background: rgb(134, 7, 207) !important;

    }

    .badge-purchased {
        background: rgb(42, 146, 0) !important;
    }




    .print_now {
        font-size: 16px
    }
</style>
<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
        

                $('[id^=changePaymentStatus]').on('click', function() {
                    let id = $(this).data('id');
                    let payment_status = $('#payment_status' + id)
                        .val();

                    let formData = {
                        '_token': '<?php echo e(csrf_token()); ?>',
                        payment_status: payment_status
                    };

                    $.ajax({
                        url: '<?php echo e(url('change_payment_status')); ?>/' +
                            id,
                        method: 'POST',
                        data: formData,
                        success: function(response) {
                            $('#changePaymentStatus' + id).modal('hide');

                            window.location.reload();
                            toastr.success('Payment status updated successfully.',
                                'Success', {
                                    timeOut: 5000,
                                });
                        },
                        error: function(response) {
                            toastr.error('Operation failed. Please try again.',
                                'Error', {
                                    timeOut: 5000,
                                });
                        },
                    });
                });
         

                $('[id^=changeBillStatus]').on('click', function() {
                    let id = $(this).data('id');
                    let payment_status = $('#bill_status' + id)
                        .val();

                    let formData = {
                        '_token': '<?php echo e(csrf_token()); ?>',
                        bill_status: bill_status
                    };

                    $.ajax({
                        url: '<?php echo e(url('change_bill_status')); ?>/' +
                            id,
                        method: 'POST',
                        data: formData,
                        success: function(response) {
                            $('#changeBillStatus' + id).modal('hide');

                            window.location.reload();
                            toastr.success('Bill status updated successfully.',
                                'Success', {
                                    timeOut: 5000,
                                });
                        },
                        error: function(response) {
                            toastr.error('Operation failed. Please try again.',
                                'Error', {
                                    timeOut: 5000,
                                });
                        },
                    });
                });
         

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backEnd.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\tailors-dev\upedia\resources\views/backEnd/finance/index.blade.php ENDPATH**/ ?>